<?php include '../include/header.php'; ?>
<?php include '../include/side_bar.php'; ?>


<?php
// Status Update Logic
if (isset($_GET['type']) && $_GET['type'] == 'status' && isset($_GET['operation']) && isset($_GET['id'])) {
    $operation = $_GET['operation'];
    $id = intval($_GET['id']);
    $status = ($operation == 'active') ? 1 : 0;

    $query = "UPDATE job SET status='$status' WHERE id='$id'";
    if (!mysqli_query($conn, $query)) {
        die("Error updating status: " . mysqli_error($conn));
    }

    // header("Location: view-job.php");
    echo "<script>window.location.href = 'view-job.php'</script>";
    exit;
}

// Delete Logic
if (isset($_GET['type']) && $_GET['type'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);

    $query = "DELETE FROM job WHERE id='$id'";
    if (!mysqli_query($conn, $query)) {
        die("Error deleting job: " . mysqli_error($conn));
    }

    // header("Location: view-job.php");
    echo "<script>window.location.href = 'view-job.php'</script>";
    exit;
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>View Jobs</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Job</p>
            </div>
        </div>

        <div class="salary_wrapper">
            <div class="salary_header">
                <h5>Jobs</h5>
                <div class="salary_header__right">
                    <a href="add-job.php"><i class="fa-solid fa-plus"></i> Add Job</a>
                </div>
            </div>

            <div class="salary-table">
                <div class="salary-box">
                    <table class="table table-striped">
                        <thead>
                            <tr class="table-head">
                                <th>S.NO</th>
                                <th>Hiring</th>
                                <th>Title</th>
                                <th>Experience</th>
                                <th>Profile</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $sql = "SELECT * FROM job ORDER BY id DESC";
                            $result = mysqli_query($conn, $sql);
                            $sno = 0;
                            $total_records = mysqli_num_rows($result);
                            while ($row = mysqli_fetch_assoc($result)) {
                                $sno++;
                                ?>
                                <tr>
                                    <td><?php echo $sno; ?></td>
                                    <td><?php echo htmlspecialchars($row['hiring']); ?></td>
                                    <td><?php echo htmlspecialchars($row['title']); ?></td>
                                    <td><?php echo htmlspecialchars($row['experience']); ?></td>
                                    <td><?php echo htmlspecialchars(substr($row['profile'], 0, 30)) . '...'; ?></td>
                                    <td>
                                        <?php if ($row['status'] == 'active'): ?>
                                            <a href="?type=status&operation=deactive&id=<?php echo $row['id']; ?>"
                                                class="btn btn-sm btn-warning">Deactivate</a>
                                        <?php else: ?>
                                            <a href="?type=status&operation=active&id=<?php echo $row['id']; ?>"
                                                class="btn btn-sm btn-success">Activate</a>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="add-job.php?id=<?php echo $row['id']; ?>" class="edit">Edit</a>
                                        <a href="?type=delete&id=<?php echo $row['id']; ?>" class="delete"
                                            onClick="return confirm('Please confirm deletion');">Delete</a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <div class="salary-box-bottom">
                        <p>Showing 1 to <?php echo $sno; ?> of <?php echo $total_records; ?> entries</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>