<?php include '../include/header.php'; ?>
<?php include '../include/side_bar.php'; ?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>View Industry</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Industry</p>
            </div>
        </div>
        <div class="salary_wrapper">
            <div class="salary_header">
                <h5>Industry</h5>
                <div class="salary_header__right">
                    <a href="add-industry.php"><i class="fa-solid fa-plus"></i> Add Industry</a>
                </div>
            </div>

            <div class="salary-table">
                <div class="salary-box">
                    <table class="table table-striped">
                        <thead>
                            <tr class="table-head">
                                <th scope="col">S.NO</th>
                                <th scope="col">Industry Name</th>
                                <th scope="col">Status</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Status & Delete Logic
                            if (isset($_GET['type']) && $_GET['type'] != '') {
                                $type = $_GET['type'];

                                if ($type == 'status') {
                                    $operation = $_GET['operation'];
                                    $id = $_GET['id'];
                                    $status = ($operation == 'active') ? '1' : '0';
                                    mysqli_query($conn, "UPDATE industry SET status='$status' WHERE id='$id'");
                                }

                                if ($type == 'delete') {
                                    $id = $_GET['id'];
                                    mysqli_query($conn, "DELETE FROM industry WHERE id='$id'");
                                    echo "<script>window.location.href='view-industry.php';</script>";
                                    die();
                                }
                            }

                            // Fetch Records
                            $sql = "SELECT * FROM industry ORDER BY id DESC";
                            $result = mysqli_query($conn, $sql);
                            $sno = 0;
                            $total_records = mysqli_num_rows($result);
                            while ($row = mysqli_fetch_assoc($result)) {
                                $sno++;
                                $status = $row['status'];
                                ?>
                                <tr>
                                    <th scope="row"><?php echo $sno; ?></th>
                                    <td><?php echo htmlspecialchars(substr($row['name'], 0, 50)); ?></td>
                                    <td>
                                        <?php if ($status == 1) { ?>
                                            <span class='btn btn-round btn-warning'>
                                                <a style='color:#fff;'
                                                    href='?type=status&operation=deactive&id=<?php echo $row['id']; ?>'>Deactivate</a>
                                            </span>
                                        <?php } else { ?>
                                            <span class='btn btn-round btn-success'>
                                                <a style='color:#fff;'
                                                    href='?type=status&operation=active&id=<?php echo $row['id']; ?>'>Activate</a>
                                            </span>
                                        <?php } ?>
                                    </td>
                                    <td>
                                        <a href="add-industry.php?id=<?php echo $row['id']; ?>" class="edit">Edit</a>
                                        <a href="?type=delete&id=<?php echo $row['id']; ?>" class="delete"
                                            onclick="return confirm('Please confirm deletion');">Delete</a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <div class="salary-box-bottom">
                        <p>Showing 1 to <?php echo $sno; ?> of <?php echo $total_records; ?> entries</p>
                        <div class="next-prev">
                            <button>Previous</button>
                            <p>1</p>
                            <button>Next</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>