<?php
include '../include/header.php';
include '../include/side_bar.php';

// Handle Deletion Securely
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = mysqli_real_escape_string($conn, $_GET['id']);
    $del = mysqli_query($conn, "DELETE FROM `contact` WHERE id = '$id'");

    if ($del) {
        echo "<script>alert('Record deleted successfully!'); window.location.href='contact.php';</script>";
    } else {
        echo "<script>alert('Error deleting record.');</script>";
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>All Contact Entries</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Contact</p>
            </div>
        </div>

        <div class="salary_wrapper">
            <div class="salary_header">
                <h5>Contact List</h5>
            </div>

            <div class="salary-table">
                <div class="salary-box">
                    <table class="table table-striped">
                        <thead>
                            <tr class="table-head">
                                <th scope="col">S.NO</th>
                                <th scope="col">Name</th>
                                <th scope="col">Phone</th>
                                <th scope="col">Email</th>
                                <th scope="col">Subject</th>
                                <th scope="col">Message</th>
                                <th scope="col">Date</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $query = mysqli_query($conn, "SELECT * FROM `contact` ORDER BY id DESC");
                            $sno = 0;
                            while ($row = mysqli_fetch_assoc($query)) {
                                $sno++;
                                ?>
                                <tr>
                                    <td><?php echo $sno; ?></td>
                                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                    <td><?php echo htmlspecialchars($row['email']); ?></td>
                                    <td><?php echo htmlspecialchars($row['subject']); ?></td>
                                    <td><?php echo nl2br(htmlspecialchars($row['message'])); ?></td>
                                    <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                                    <td>
                                        <a href="contact.php?id=<?php echo $row['id']; ?>" class="btn btn-danger"
                                            onclick="return confirm('Are you sure you want to delete this record?');">
                                            Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <!-- Optional pagination footer -->
                    <div class="salary-box-bottom">
                        <p>Total Records: <?php echo $sno; ?></p>
                        <div class="next-prev">
                            <button disabled>Previous</button>
                            <p>1</p>
                            <button disabled>Next</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>