<style>
    .error-msg {
        color: red;
        padding-bottom: 1rem;
    }
</style>

<?php
include '../include/header.php';
include '../include/side_bar.php';
include '../include/function.inc.php';

$id = "";
$cat_name = "";
$sub_name = "";
$slug = "";
$short_desc = "";
$msg = "";

// Slug Generator
function generateSlug($string)
{
    $slug = strtolower(trim($string));
    $slug = preg_replace('/[^a-z0-9-]/', '-', $slug);
    $slug = preg_replace('/-+/', '-', $slug);
    return rtrim($slug, '-');
}

// Fetch existing data for edit
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $id = intval($_GET['id']);
    $sql = "SELECT * FROM `sub_categories` WHERE id = '$id'";
    $result = mysqli_query($conn, $sql);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $cat_name = $row['cat_name'];
        $sub_name = $row['sub_name'];
        $slug = $row['slug'];
        $short_desc = $row['short_desc'];
    } else {
        echo "<script>window.location.href = 'view-sub-categories.php';</script>";
        exit;
    }
}

// Insert / Update
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $id = intval($_POST['id']);
    $cat_name = mysqli_real_escape_string($conn, $_POST['cat_name']);
    $sub_name = mysqli_real_escape_string($conn, $_POST['sub_name']);
    $short_desc = mysqli_real_escape_string($conn, $_POST['short_desc']);
    $slug = generateSlug($sub_name);

    // Duplicate check
    $check_sql = "SELECT id FROM `sub_categories` WHERE sub_name = '$sub_name' AND id != '$id'";
    $check_result = mysqli_query($conn, $check_sql);

    if (mysqli_num_rows($check_result) > 0) {
        $msg = "Sub Category already exists";
    } else {
        if (!empty($id)) {
            $sql = "UPDATE `sub_categories` 
                    SET `cat_name`='$cat_name', 
                        `sub_name`='$sub_name', 
                        `short_desc`='$short_desc', 
                        `slug`='$slug' 
                    WHERE `id`='$id'";
            $action = "updated";
        } else {
            // Insert
            $sql = "INSERT INTO `sub_categories` 
                    (`cat_name`, `sub_name`, `short_desc`, `slug`, `status`) 
                    VALUES ('$cat_name', '$sub_name', '$short_desc', '$slug', 1)";
            $action = "inserted";
        }

        if (mysqli_query($conn, $sql)) {
            echo "<script>alert('Record $action successfully!'); window.location.href = 'view-sub-categories.php';</script>";
            exit;
        } else {
            $msg = "Error: " . mysqli_error($conn);
        }
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? 'Edit' : 'Add'; ?> Sub Categories</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Sub Categories</p>
            </div>
        </div>

        <div class="category_wrapper">
            <form action="" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <select name="cat_name" id="cat_name" class="form-control" required>
                                <option value="">Select Category</option>

                                <?php
                                $sql = "SELECT * FROM `categories`";
                                $result = mysqli_query($conn, $sql);
                                while ($row = mysqli_fetch_assoc($result)) {
                                    $selected = ($cat_name == $row['id']) ? 'selected' : '';
                                    echo '<option value="' . $row['id'] . '" ' . $selected . '>' . $row['categories'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Sub Category Name</label>
                            <input type="text" class="form-control" name="sub_name"
                                value="<?php echo htmlspecialchars($sub_name); ?>" required>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="mb-3">
                            <label class="form-label">Short Description</label>
                            <textarea class="form-control" name="short_desc" rows="3"
                                required><?php echo htmlspecialchars($short_desc); ?></textarea>
                        </div>
                    </div>
                </div>

                <div class="error-msg"><?php echo $msg; ?></div>

                <button type="submit" name="submit" class="btn btn-primary">
                    <?php echo $id ? 'Update' : 'Submit'; ?>
                </button>
            </form>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>