<?php
include '../include/header.php';
include '../include/side_bar.php';

// Delete record
if (isset($_GET['delete_id'])) {
    $id = $_GET['delete_id'];
    $res = mysqli_query($conn, "SELECT image FROM gallery WHERE id='$id'");
    if ($row = mysqli_fetch_assoc($res)) {
        $file = '../uploads/' . $row['image'];
        if (file_exists($file))
            unlink($file);
    }
    mysqli_query($conn, "DELETE FROM gallery WHERE id='$id'");
    echo "<script>alert('Deleted successfully'); window.location.href='add-gallery.php';</script>";
    exit;
}

// Insert multiple
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    $headings = $_POST['heading'];
    foreach ($_FILES['image']['name'] as $key => $name) {
        $heading = mysqli_real_escape_string($conn, $headings[$key]);
        $tmp_name = $_FILES['image']['tmp_name'][$key];

        if (!empty($name) && !empty($heading)) {
            $filename = time() . '_' . basename($name);
            $target = '../uploads/' . $filename;

            if (move_uploaded_file($tmp_name, $target)) {
                mysqli_query($conn, "INSERT INTO gallery (heading, image, status) VALUES ('$heading', '$filename', 1)");
            }
        }
    }
    echo "<script>alert('Gallery items inserted'); window.location.href='view-gallery.php';</script>";
    exit;
}

// Update record
if (isset($_POST['update_id'])) {
    $id = $_POST['update_id'];
    $heading = mysqli_real_escape_string($conn, $_POST['heading']);
    $filename = '';

    if (!empty($_FILES['image']['name'])) {
        $filename = time() . '_' . basename($_FILES['image']['name']);
        $target = '../uploads/' . $filename;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $target)) {
            $res = mysqli_query($conn, "SELECT image FROM gallery WHERE id='$id'");
            if ($row = mysqli_fetch_assoc($res)) {
                $file = '../uploads/' . $row['image'];
                if (file_exists($file))
                    unlink($file);
            }
            mysqli_query($conn, "UPDATE gallery SET image='$filename' WHERE id='$id'");
        }
    }

    mysqli_query($conn, "UPDATE gallery SET heading='$heading' WHERE id='$id'");
    echo "<script>alert('Gallery item updated'); window.location.href='add-gallery.php';</script>";
    exit;
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>Add Gallery Items</h3>
        </div>

        <form method="post" enctype="multipart/form-data">
            <div id="gallery-items">
                <div class="row gallery-item mb-3">
                    <div class="col-md-5">
                        <input type="text" name="heading[]" class="form-control" placeholder="Heading" required>
                    </div>
                    <div class="col-md-5">
                        <input type="file" name="image[]" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-danger remove-item">Remove</button>
                    </div>
                </div>
            </div>
            <button type="button" class="btn btn-secondary mb-3" id="add-more">Add More</button>
            <button type="submit" name="submit" class="btn btn-primary">Submit</button>
        </form>

        <hr>

        <h4>Gallery List</h4>
        <table class="table table-bordered">
            <tbody>
                <?php
                $res = mysqli_query($conn, "SELECT * FROM gallery ORDER BY id DESC");
                while ($row = mysqli_fetch_assoc($res)):
                    ?>
                    <tr>
                        <form method="post" enctype="multipart/form-data">
                            <input type="hidden" name="update_id" value="<?php echo $row['id']; ?>">
                            <td><?php echo $row['id']; ?></td>
                            <td><input type="text" name="heading" class="form-control"
                                    value="<?php echo htmlspecialchars($row['heading']); ?>" required></td>
                            <td>
                                <input type="file" name="image" class="form-control mt-1">
                                <img src="../uploads/<?php echo $row['image']; ?>" width="60">
                            </td>
                            <td>
                                <button type="submit" class="btn btn-success btn-sm mb-1">Update</button>
                                <a href="?delete_id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm"
                                    onclick="return confirm('Delete this item?')">Delete</a>
                            </td>
                        </form>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</main>

<script>
    document.getElementById('add-more').addEventListener('click', function () {
        const wrapper = document.getElementById('gallery-items');
        const item = document.createElement('div');
        item.className = 'row gallery-item mb-3';
        item.innerHTML = `
        <div class="col-md-5">
            <input type="text" name="heading[]" class="form-control" placeholder="Heading" required>
        </div>
        <div class="col-md-5">
            <input type="file" name="image[]" class="form-control" required>
        </div>
        <div class="col-md-2">
            <button type="button" class="btn btn-danger remove-item">Remove</button>
        </div>
    `;
        wrapper.appendChild(item);
    });

    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-item')) {
            e.target.closest('.gallery-item').remove();
        }
    });
</script>

<?php include '../include/footer.php'; ?>