<?php
include '../include/header.php';
include '../include/side_bar.php';

// DELETE FAQ
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    mysqli_query($conn, "DELETE FROM faq WHERE id='$id'");
    echo "<script>alert('FAQ deleted successfully'); window.location.href='add-faq.php';</script>";
    exit;
}

// INSERT MULTIPLE FAQs
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    foreach ($_POST['heading'] as $key => $heading) {
        $heading = mysqli_real_escape_string($conn, $heading);
        $description = mysqli_real_escape_string($conn, $_POST['description'][$key]);

        if (!empty($heading) && !empty($description)) {
            mysqli_query($conn, "INSERT INTO faq (heading, description, status) VALUES ('$heading', '$description', 1)");
        }
    }
    echo "<script>alert('FAQs added successfully'); window.location.href='add-faq.php';</script>";
    exit;
}

// UPDATE FAQ
if (isset($_POST['update_id'])) {

    $id = intval($_POST['update_id']);
    $heading = mysqli_real_escape_string($conn, $_POST['heading']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    mysqli_query($conn, "UPDATE faq SET heading='$heading', description='$description' WHERE id='$id'");
    echo "<script>alert('FAQ updated successfully'); window.location.href='add-faq.php';</script>";
    exit;
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <?php
        if (!isset($_GET['id'])):
            ?>
            <div class="dashboard_heading">
                <h3>Add FAQ</h3>
            </div>

            <!-- ADD MULTIPLE FAQs -->
            <form method="post">
                <div id="faq-items">
                    <div class="row faq-item mb-3">
                        <div class="col-md-12 mb-2">
                            <input type="text" name="heading[]" class="form-control" placeholder="Heading" required>
                        </div>
                        <div class="col-md-12">
                            <textarea name="description[]" class="form-control" placeholder="Description"
                                required></textarea>
                        </div>
                        <div class="col-md-2 mt-2">
                            <button type="button" class="btn btn-danger remove-item">Remove</button>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-secondary" id="add-more">Add More</button>
                <button type="submit" name="submit" class="btn btn-primary">Save FAQs</button>
            </form>

            <hr>
        <?php endif; ?>
        <!-- LIST FAQs -->
        <h4>FAQ List</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Heading</th>
                    <th>Description</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $res = mysqli_query($conn, "SELECT * FROM faq ORDER BY id DESC");
                while ($row = mysqli_fetch_assoc($res)):
                    ?>
                    <tr>
                        <form method="post">
                            <input type="hidden" name="update_id" value="<?php echo $row['id']; ?>">
                            <td><?php echo $row['id']; ?></td>
                            <td><input type="text" name="heading" value="<?php echo htmlspecialchars($row['heading']); ?>"
                                    class="form-control"></td>
                            <td><textarea name="description"
                                    class="form-control"><?php echo htmlspecialchars($row['description']); ?></textarea>
                            </td>
                            <td>
                                <button type="submit" class="btn btn-success btn-sm mb-1">Update</button>
                                <a href="?delete_id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm"
                                    onclick="return confirm('Delete this FAQ?')">Delete</a>
                            </td>
                        </form>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</main>

<script>
    document.getElementById('add-more').addEventListener('click', function () {
        const wrapper = document.getElementById('faq-items');
        const item = document.createElement('div');
        item.className = 'row faq-item mb-3';
        item.innerHTML = `
            <div class="col-md-12 mb-2">
                <input type="text" name="heading[]" class="form-control" placeholder="Heading" required>
            </div>
            <div class="col-md-12 mb-2">
                <textarea name="description[]" class="form-control" placeholder="Description" required></textarea>
            </div>
            <div class="col-md-2 ">
                <button type="button" class="btn btn-danger remove-item">Remove</button>
            </div>
        `;
        wrapper.appendChild(item);
    });

    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-item')) {
            e.target.closest('.faq-item').remove();
        }
    });
</script>

<?php include '../include/footer.php'; ?>