<?php
include '../include/header.php';
include '../include/side_bar.php';

$id = "";
$type = "";
$heading = "";
$description = "";
$image = "";


if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "SELECT * FROM `about` WHERE id = '$id'";
    $result = mysqli_query($conn, $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        $type = $row['type'];
        $heading = $row['heading'];
        $description = $row['description'];
        $image = $row['image'];
    }
}


if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $id = $_POST['id'] ?? "";
    $type = mysqli_real_escape_string($conn, $_POST['type']);
    $heading = mysqli_real_escape_string($conn, $_POST['heading']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $image_upload = false;

    // Handle Image Upload
    if (!empty($_FILES['image']['name'])) {
        $image_name = time() . '_' . basename($_FILES['image']['name']);
        $target_dir = "../uploads/";
        $target_file = $target_dir . $image_name;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
            $image_upload = true;

            // Delete old image if updating
            if ($id) {
                $old_image_query = mysqli_query($conn, "SELECT image FROM about WHERE id = '$id'");
                if ($old_row = mysqli_fetch_assoc($old_image_query)) {
                    $old_image = $old_row['image'];
                    if (!empty($old_image)) {
                        $old_image_path = $target_dir . $old_image;
                        if (file_exists($old_image_path)) {
                            unlink($old_image_path);
                        }
                    }
                }
            }
            $image = $image_name; // Update image name
        } else {
            echo "<script>alert('Image upload failed!');</script>";
        }
    }

    // Update or Insert Query
    if ($id) {
        if ($image_upload) {
            $sql = "UPDATE `about` SET `type`='$type', `heading`='$heading', `image`='$image', `description`='$description' WHERE `id`='$id'";
        } else {
            $sql = "UPDATE `about` SET `type`='$type', `heading`='$heading', `description`='$description' WHERE `id`='$id'";
        }
        $msg = "Updated";
    } else {
        $sql = "INSERT INTO `about` (`type`, `heading`, `image`, `description`) VALUES ('$type', '$heading', '$image', '$description')";
        $msg = "Inserted";
    }

    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Record $msg successfully!'); window.location.href = 'view-about.php'; </script>";
    } else {
        echo "<script>alert('Error: " . mysqli_error($conn) . "');</script>";
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? 'Edit' : 'Add'; ?> About</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>About</p>
            </div>
        </div>

        <div class="about_wrapper">
            <form action="#" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="type" class="form-label">Type</label>
                            <select name="type" class="form-control" required>
                                <option value="">Select Type</option>
                                <option value="one" <?php echo ($type == 'one') ? 'selected' : ''; ?>>Home Page About
                                </option>
                                <option value="two" <?php echo ($type == 'two') ? 'selected' : ''; ?>>About Section
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="heading" class="form-label">Heading</label>
                            <input type="text" class="form-control" name="heading"
                                value="<?php echo htmlspecialchars($heading); ?>" required>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="image" class="form-label">Image</label>
                            <input type="file" class="form-control" name="image">
                            <?php if (!empty($image)): ?>
                                <img src="../uploads/<?php echo htmlspecialchars($image); ?>" width="100" class="mt-2"
                                    onerror="this.style.display='none'">
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control"
                                name="description"><?php echo htmlspecialchars($description); ?></textarea>
                        </div>
                    </div>
                </div>

                <button type="submit" name="submit"
                    class="btn btn-primary"><?php echo $id ? 'Update' : 'Submit'; ?></button>
            </form>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>